use master
GO

set nocount on 

--set to 0 to skip updating the A4Survey_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @ClientPayload01 nvarchar(max) = N'
-- DEV-95536  703007
IF NOT EXISTS (SELECT 1 FROM sys.columns WHERE [object_id] = OBJECT_ID(''[SAT].[BlocksRandomizations]'') AND [name] = ''SeedAjustment'')
BEGIN
	ALTER TABLE [SAT].[BlocksRandomizations]
	ADD [SeedAjustment] [int] NULL
END
'

declare @ClientPayload02 nvarchar(max) = N'
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[SAT].[VX_sp_PublishQuestionnaireVersion]'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE [SAT].[VX_sp_PublishQuestionnaireVersion]
'

declare @ClientPayload03 nvarchar(max) = N'
CREATE PROCEDURE [SAT].[VX_sp_PublishQuestionnaireVersion]
 @iQuestionnaireId int,
 @iVersion int = 0,
 @iUserId int = 0,
 @errorFlags int output
AS
BEGIN

 SET @errorFlags = 0;
 SET NOCOUNT ON;
    --
    -- Declare tables that will store all the ids to copy
    --
    CREATE TABLE #tblQuestionnaireVersions ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblChoices ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblBlocks ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogicConditions ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblQuestionsRandomizations ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblBlockItems ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblVariables ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblChoiceSettings ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblQuestionSettings ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblQuestionActions ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSurveyOptions ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblQuestionnaireLanguages ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblChoiceLists ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblShortcuts ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogics ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblBlocksRandomizations ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblThemes ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblThemeElementProperties ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblQuestionActionProperties ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblVariableSettings ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblBlockItems_Question ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_QuestionShortText ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_QuestionText ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_QuestionTitle ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_QuestionnaireMessageText ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_QuestionnaireTerminationText ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_ChoiceText ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_ShortcutButtonText ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_TranslatableQuestionSetting ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblQuestionActions_QuestionPreLoadAction ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblQuestionActions_QuestionPostAnswerAction ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_ThemeText ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogics_QuestionAskLogic ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogics_SkipQuestionLogic ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogics_BlockSkipLogic ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogics_QuestionSettingSkipLogic ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogics_VariableSkipLogic ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogics_ChoiceSkipLogic ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogics_ChoiceDisplayLogic ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_TranslatableVariableSetting ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogics_QuestionActionExecutionCondition ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_TranslatableChoiceSetting ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblBlockItems_PageBreak ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblBlockItems_LibraryQuestion ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblThemes_LibraryTheme ( [Id] int, PRIMARY KEY ([Id]) );
    
    --
    -- Retrieves ids
    --
    
    DECLARE @iItemCount bigint
    SET @iItemCount = 1;
    
      
    -- Set the next version for the questionnaire. This will be the published version
    DECLARE @iCurrentVersion int
    DECLARE @iNextVersion int
    DECLARE @iContextId int
      
    IF @iVersion = 0 
    BEGIN
     SET @iCurrentVersion = 0; -- Publishing from version 0
     SELECT @iNextVersion = (ISNULL(MAX([Version]), 0) + 1) FROM [SAT].[QuestionnaireVersions] WHERE [Id] = @iQuestionnaireId;
    END
    ELSE
    BEGIN
     SET @iCurrentVersion = @iVersion;   -- Publishing provided version 
     SET @iNextVersion = 0;    -- Setting the edit version
    END
    
    SELECT @iContextId = [ContextId] FROM [SAT].[Questionnaires] WHERE [Id] = @iQuestionnaireId;
   
 INSERT INTO #tblQuestionnaireVersions ([Id]) VALUES (@iQuestionnaireId);
 SET @iItemCount = 1;


 INSERT INTO #tblQuestionnaireLanguages ([Id]) SELECT [Id] FROM [SAT].QuestionnaireLanguages ins WHERE [Version] = @iCurrentVersion AND [QuestionnaireId] = @iQuestionnaireId AND NOT EXISTS (SELECT NULL FROM #tblQuestionnaireLanguages tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 -- #tblSurveyOptions
 INSERT INTO #tblSurveyOptions ([Id]) SELECT [Id] FROM [SAT].SurveyOptions ins WHERE [Version] = @iCurrentVersion AND [Id] = @iQuestionnaireId AND NOT EXISTS (SELECT NULL FROM #tblSurveyOptions tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 -- #tblBlocks
 INSERT INTO #tblBlocks ([Id]) SELECT [Id] FROM [SAT].Blocks ins WHERE [Version] = @iCurrentVersion AND [QuestionnaireId] = @iQuestionnaireId AND NOT EXISTS (SELECT NULL FROM #tblBlocks tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 -- #tblBlockItems
 INSERT INTO #tblBlockItems ([Id]) SELECT [Id] FROM [SAT].BlockItems ins WHERE [Version] = @iCurrentVersion AND [BlockId] IN (SELECT [Id] FROM #tblBlocks ) AND NOT EXISTS (SELECT NULL FROM #tblBlockItems tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 -- #tblBlockItems_Question
 INSERT INTO #tblBlockItems_Question ([Id]) SELECT [Id] FROM [SAT].BlockItems_Question ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlockItems ) AND NOT EXISTS (SELECT NULL FROM #tblBlockItems_Question tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblBlockItems_PageBreak ([Id]) SELECT [Id] FROM [SAT].BlockItems_PageBreak ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlockItems ) AND NOT EXISTS (SELECT NULL FROM #tblBlockItems_PageBreak tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblBlockItems_LibraryQuestion ([Id]) SELECT [Id] FROM [SAT].BlockItems_LibraryQuestion ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlockItems_Question ) AND NOT EXISTS (SELECT NULL FROM #tblBlockItems_LibraryQuestion tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 --#tblChoiceLists
 INSERT INTO #tblChoiceLists ([Id]) SELECT [Id] FROM [SAT].ChoiceLists ins WHERE [Version] = @iCurrentVersion AND [QuestionnaireVersionId] = @iQuestionnaireId AND NOT EXISTS (SELECT NULL FROM #tblChoiceLists tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 --#tblChoices
 INSERT INTO #tblChoices ([Id]) SELECT [Id] FROM [SAT].Choices ins WHERE [Version] = @iCurrentVersion AND [ChoiceListId] IN (SELECT [Id] FROM #tblChoiceLists ) AND NOT EXISTS (SELECT NULL FROM #tblChoices tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 -- #tblVariables
 INSERT INTO #tblVariables ([Id]) SELECT [Id] FROM [SAT].Variables ins WHERE [Version] = @iCurrentVersion AND [QuestionId] IN (SELECT [Id] FROM #tblBlockItems_Question ) AND NOT EXISTS (SELECT NULL FROM #tblVariables tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 --#tblQuestionActions
 INSERT INTO #tblQuestionActions_QuestionPreLoadAction ([Id]) SELECT [Id] FROM [SAT].QuestionActions_QuestionPreLoadAction ins WHERE [Version] = @iCurrentVersion AND [QuestionId] IN (SELECT [Id] FROM #tblBlockItems_Question ) AND NOT EXISTS (SELECT NULL FROM #tblQuestionActions_QuestionPreLoadAction tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblQuestionActions_QuestionPostAnswerAction ([Id]) SELECT [Id] FROM [SAT].QuestionActions_QuestionPostAnswerAction ins WHERE [Version] = @iCurrentVersion AND [QuestionId] IN (SELECT [Id] FROM #tblBlockItems_Question ) AND NOT EXISTS (SELECT NULL FROM #tblQuestionActions_QuestionPostAnswerAction tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblQuestionActions ([Id]) SELECT DISTINCT [Id] FROM [SAT].QuestionActions_QuestionPreLoadAction ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionActions_QuestionPreLoadAction ) AND NOT EXISTS (SELECT NULL FROM #tblQuestionActions tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblQuestionActions ([Id]) SELECT DISTINCT [Id] FROM [SAT].QuestionActions_QuestionPostAnswerAction ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionActions_QuestionPostAnswerAction ) AND NOT EXISTS (SELECT NULL FROM #tblQuestionActions tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 -- #tblSkipLogics
 INSERT INTO #tblSkipLogics ([Id]) SELECT [Id] FROM [SAT].SkipLogics ins WHERE [Version] = @iCurrentVersion AND [QuestionnaireId] = @iQuestionnaireId AND NOT EXISTS (SELECT NULL FROM #tblSkipLogics tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblSkipLogicConditions ([Id]) SELECT [Id] FROM [SAT].SkipLogicConditions ins WHERE [Version] = @iCurrentVersion AND [VariableToEvaluateId] IN (SELECT [Id] FROM #tblVariables ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogicConditions tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblSkipLogicConditions ([Id]) SELECT [Id] FROM [SAT].SkipLogicConditions ins WHERE [Version] = @iCurrentVersion AND [ShortcutId] IN (SELECT [Id] FROM #tblSkipLogics ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogicConditions tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 -- #tblQuestionsRandomizations
 INSERT INTO #tblQuestionsRandomizations ([Id]) SELECT [Id] FROM [SAT].QuestionsRandomizations ins WHERE [Version] = @iCurrentVersion AND [BlockId] IN (SELECT [Id] FROM #tblBlocks ) AND NOT EXISTS (SELECT NULL FROM #tblQuestionsRandomizations tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblChoiceSettings ([Id]) SELECT [Id] FROM [SAT].ChoiceSettings ins WHERE [Version] = @iCurrentVersion AND [ChoiceId] IN (SELECT [Id] FROM #tblChoices ) AND NOT EXISTS (SELECT NULL FROM #tblChoiceSettings tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblSkipLogics_QuestionSettingSkipLogic ([Id]) SELECT [Id] FROM [SAT].SkipLogics_QuestionSettingSkipLogic ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogics_QuestionSettingSkipLogic tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblQuestionSettings ([Id]) SELECT [Id] FROM [SAT].QuestionSettings ins WHERE [Version] = @iCurrentVersion AND [QuestionId] IN (SELECT [Id] FROM #tblBlockItems_Question ) AND NOT EXISTS (SELECT NULL FROM #tblQuestionSettings tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblQuestionActionProperties ([Id]) SELECT [Id] FROM [SAT].QuestionActionProperties ins WHERE [Version] = @iCurrentVersion AND [QuestionActionId] IN (SELECT [Id] FROM #tblQuestionActions ) AND NOT EXISTS (SELECT NULL FROM #tblQuestionActionProperties tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblVariableSettings ([Id]) SELECT [Id] FROM [SAT].VariableSettings ins WHERE [Version] = @iCurrentVersion AND [VariableId] IN (SELECT [Id] FROM #tblVariables ) AND NOT EXISTS (SELECT NULL FROM #tblVariableSettings tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblLocalizableTexts_QuestionShortText ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_QuestionShortText ins WHERE [Version] = @iCurrentVersion AND [QuestionId] IN (SELECT [Id] FROM #tblBlockItems_Question ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_QuestionShortText tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_QuestionShortText ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionShortText ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblLocalizableTexts_QuestionText ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_QuestionText ins WHERE [Version] = @iCurrentVersion AND [QuestionId] IN (SELECT [Id] FROM #tblBlockItems_Question ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_QuestionText tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_QuestionText ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionText ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

    INSERT INTO #tblLocalizableTexts_QuestionTitle ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_QuestionTitle ins WHERE [Version] = @iCurrentVersion AND [QuestionId] IN (SELECT [Id] FROM #tblBlockItems_Question ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_QuestionTitle tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_QuestionTitle ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionTitle ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblLocalizableTexts_QuestionnaireMessageText ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_QuestionnaireMessageText ins WHERE [Version] = @iCurrentVersion AND [QuestionnaireId] IN (SELECT [Id] FROM #tblQuestionnaireVersions ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_QuestionnaireMessageText tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_QuestionnaireMessageText ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionnaireMessageText ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblLocalizableTexts_QuestionnaireTerminationText ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_QuestionnaireTerminationText ins WHERE [Version] = @iCurrentVersion AND [QuestionnaireId] = @iQuestionnaireId AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_QuestionnaireTerminationText tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_QuestionnaireTerminationText ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionnaireTerminationText ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblLocalizableTexts_ChoiceText ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_ChoiceText ins WHERE [Version] = @iCurrentVersion AND [ChoiceId] IN (SELECT [Id] FROM #tblChoices ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_ChoiceText tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_ChoiceText ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_ChoiceText ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblLocalizableTexts_TranslatableQuestionSetting ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_TranslatableQuestionSetting ins WHERE [Version] = @iCurrentVersion AND [QuestionId] IN (SELECT [Id] FROM #tblBlockItems_Question ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_TranslatableQuestionSetting tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_TranslatableQuestionSetting ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_TranslatableQuestionSetting ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblSkipLogics_QuestionAskLogic ([Id]) SELECT [Id] FROM [SAT].SkipLogics_QuestionAskLogic ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogics_QuestionAskLogic tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblSkipLogics_SkipQuestionLogic ([Id]) SELECT [Id] FROM [SAT].SkipLogics_SkipQuestionLogic ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogics_SkipQuestionLogic tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblSkipLogics_BlockSkipLogic ([Id]) SELECT [Id] FROM [SAT].SkipLogics_BlockSkipLogic ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogics_BlockSkipLogic tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT


 INSERT INTO #tblSkipLogics_VariableSkipLogic ([Id]) SELECT [Id] FROM [SAT].SkipLogics_VariableSkipLogic ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogics_VariableSkipLogic tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblSkipLogics_ChoiceSkipLogic ([Id]) SELECT [Id] FROM [SAT].SkipLogics_ChoiceSkipLogic ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogics_ChoiceSkipLogic tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblSkipLogics_ChoiceDisplayLogic ([Id]) SELECT [Id] FROM [SAT].SkipLogics_ChoiceDisplayLogic ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogics_ChoiceDisplayLogic tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT


 INSERT INTO #tblLocalizableTexts_TranslatableVariableSetting ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_TranslatableVariableSetting ins WHERE [Version] = @iCurrentVersion AND [VariableId] IN (SELECT [Id] FROM #tblVariables ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_TranslatableVariableSetting tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_TranslatableVariableSetting ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_TranslatableVariableSetting ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblSkipLogics_QuestionActionExecutionCondition ([Id]) SELECT [Id] FROM [SAT].SkipLogics_QuestionActionExecutionCondition ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogics_QuestionActionExecutionCondition tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblLocalizableTexts_TranslatableChoiceSetting ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_TranslatableChoiceSetting ins WHERE [Version] = @iCurrentVersion AND [ChoiceId] IN (SELECT [Id] FROM #tblChoices ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_TranslatableChoiceSetting tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_TranslatableChoiceSetting ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_TranslatableChoiceSetting ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 -- #tblShortcuts
 INSERT INTO #tblShortcuts ([Id]) SELECT [Id] FROM [SAT].Shortcuts ins WHERE [Version] = @iCurrentVersion AND [BlockId] IN (SELECT [Id] FROM #tblBlocks ) AND NOT EXISTS (SELECT NULL FROM #tblShortcuts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblShortcuts ([Id]) SELECT [Id] FROM [SAT].Shortcuts ins WHERE [Version] = @iCurrentVersion AND [SurveyOptionsId] IN (SELECT [Id] FROM #tblSurveyOptions ) AND NOT EXISTS (SELECT NULL FROM #tblShortcuts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblShortcuts ([Id]) SELECT DISTINCT [ShortcutId] FROM [SAT].LocalizableTexts_ShortcutButtonText ins WHERE [ShortcutId] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_ShortcutButtonText ) AND NOT EXISTS (SELECT NULL FROM #tblShortcuts tbl WHERE ins.[ShortcutId] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 -- #tblBlocksRandomizations
 INSERT INTO #tblBlocksRandomizations ([Id]) SELECT [Id] FROM [SAT].BlocksRandomizations ins WHERE [Version] = @iCurrentVersion AND [SurveyOptionsId] IN (SELECT [Id] FROM #tblSurveyOptions ) AND NOT EXISTS (SELECT NULL FROM #tblBlocksRandomizations tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT


 INSERT INTO #tblLocalizableTexts_ShortcutButtonText ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_ShortcutButtonText ins WHERE [Version] = @iCurrentVersion AND [ShortcutId] IN (SELECT [Id] FROM #tblShortcuts ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_ShortcutButtonText tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_ShortcutButtonText ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_ShortcutButtonText ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT


 -- #tblThemes
 INSERT INTO #tblThemes ([Id]) SELECT DISTINCT [Theme_Id] FROM [SAT].Blocks ins WHERE [Theme_Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlocks ) AND NOT EXISTS (SELECT NULL FROM #tblThemes tbl WHERE ins.[Theme_Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblThemes ([Id]) SELECT DISTINCT [Theme_Id] FROM [SAT].QuestionnaireVersions ins WHERE [Theme_Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionnaireVersions ) AND NOT EXISTS (SELECT NULL FROM #tblThemes tbl WHERE ins.[Theme_Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblThemes ([Id]) SELECT DISTINCT [ThemeId] FROM [SAT].ThemeElementProperties ins WHERE [ThemeId] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblThemeElementProperties ) AND NOT EXISTS (SELECT NULL FROM #tblThemes tbl WHERE ins.[ThemeId] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblThemes ([Id]) SELECT DISTINCT [ThemeId] FROM [SAT].LocalizableTexts_ThemeText ins WHERE [ThemeId] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_ThemeText ) AND NOT EXISTS (SELECT NULL FROM #tblThemes tbl WHERE ins.[ThemeId] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblThemes ([Id]) SELECT DISTINCT [Id] FROM [SAT].Themes_LibraryTheme ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblThemes_LibraryTheme ) AND NOT EXISTS (SELECT NULL FROM #tblThemes tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblThemeElementProperties ([Id]) SELECT [Id] FROM [SAT].ThemeElementProperties ins WHERE [Version] = @iCurrentVersion AND [ThemeId] IN (SELECT [Id] FROM #tblThemes ) AND NOT EXISTS (SELECT NULL FROM #tblThemeElementProperties tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblThemes_LibraryTheme ([Id]) SELECT [Id] FROM [SAT].Themes_LibraryTheme ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblThemes ) AND NOT EXISTS (SELECT NULL FROM #tblThemes_LibraryTheme tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblLocalizableTexts_ThemeText ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_ThemeText ins WHERE [Version] = @iCurrentVersion AND [ThemeId] IN (SELECT [Id] FROM #tblThemes ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_ThemeText tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_ThemeText ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_ThemeText ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

    IF (SELECT COUNT(*) FROM #tblQuestionnaireVersions) > 1 BEGIN
     SET @errorFlags = 0x01
    END
     

 SET IDENTITY_INSERT [SAT].[Themes] ON; 
   INSERT INTO [SAT].[Themes] ([Id], [Version], [ThemeCategoryId], [Name], [PageHeaderVisible], [PageFooterVisible], [PageTitleVisible], [ProgressBarVisible], [ProgressBarLocationType], [ProgressBarShowPercentage], [ProgressBarShowLabel], [QuestionNameVisible], [QuestionLabelVisible], [BackButtonVisible], [BackButtonDisplayPositionType], [BackButtonType], [NextButtonVisible], [NextButtonDisplayPositionType], [NextButtonType], [QuitButtonVisible], [QuitButtonDisplayPositionType], [QuitButtonType], [RadioButtonType], [CheckBoxButtonType], [SurveyShortcutVisible], [SurveyShortcutLocationType], [QuestionBgSameAsBlock], [QuestionBlockBgSameAsPage], [HEAD], [CustomCSS], [CustomJavascript], [LastModifiedBy], [LastModificationDate], [CreatedBy], [CreationDate], [LanguageSelectorVisible], [LanguageSelectorLocationType], [LanguageSelectorShowLabel], [LanguageSelectorType], [MobileUseStandardButtons], [CenterQuestions], [ClearButtonVisible], [ClearButtonDisplayPositionType], [ClearButtonType], [TerminateButtonVisible], [TerminateButtonDisplayPositionType], [TerminateButtonType], [TooltipsVisible], [UsePageHeaderMobile], [UsePageFooterMobile], [PrintResponsesButtonVisible], [PrintResponsesButtonLocationType], [SettingsJson], [EnableBacklink]) 
                 SELECT [Id], @iNextVersion, [ThemeCategoryId], [Name], [PageHeaderVisible], [PageFooterVisible], [PageTitleVisible], [ProgressBarVisible], [ProgressBarLocationType], [ProgressBarShowPercentage], [ProgressBarShowLabel], [QuestionNameVisible], [QuestionLabelVisible], [BackButtonVisible], [BackButtonDisplayPositionType], [BackButtonType], [NextButtonVisible], [NextButtonDisplayPositionType], [NextButtonType], [QuitButtonVisible], [QuitButtonDisplayPositionType], [QuitButtonType], [RadioButtonType], [CheckBoxButtonType], [SurveyShortcutVisible], [SurveyShortcutLocationType], [QuestionBgSameAsBlock], [QuestionBlockBgSameAsPage], [HEAD], [CustomCSS], [CustomJavascript], [LastModifiedBy], [LastModificationDate], [CreatedBy], [CreationDate], [LanguageSelectorVisible], [LanguageSelectorLocationType], [LanguageSelectorShowLabel], [LanguageSelectorType], [MobileUseStandardButtons], [CenterQuestions], [ClearButtonVisible], [ClearButtonDisplayPositionType], [ClearButtonType], [TerminateButtonVisible], [TerminateButtonDisplayPositionType], [TerminateButtonType], [TooltipsVisible], [UsePageHeaderMobile], [UsePageFooterMobile], [PrintResponsesButtonVisible], [PrintResponsesButtonLocationType], [SettingsJson], [EnableBacklink]
            FROM [SAT].[Themes] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblThemes) ;
    SET IDENTITY_INSERT [SAT].[Themes] OFF; 
            
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
 
    INSERT INTO [SAT].[QuestionnaireVersions] ([Id], [Version], [CreationDate], [CreatedBy], [LastModificationDate], [LastModifiedBy], [PublishedDate], [PublishedBy], [Theme_Id], [Theme_Version]) 
            SELECT [Id], @iNextVersion, [CreationDate], [CreatedBy], [LastModificationDate], [LastModifiedBy], [PublishedDate], [PublishedBy], [Theme_Id], (CASE WHEN [Theme_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[QuestionnaireVersions] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionnaireVersions) 
            
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
 SET IDENTITY_INSERT [SAT].[QuestionnaireLanguages] ON; 
    INSERT INTO [SAT].[QuestionnaireLanguages] ([Id], [Version], [Language], [QuestionnaireId]) 
            SELECT [Id], @iNextVersion, [Language], [QuestionnaireId] 
            FROM [SAT].[QuestionnaireLanguages] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionnaireLanguages) 
    SET IDENTITY_INSERT [SAT].[QuestionnaireLanguages] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
 SET IDENTITY_INSERT [SAT].[LocalizableTexts] ON; 
    INSERT INTO [SAT].[LocalizableTexts] ([Id], [Version], [Language], [Text]) 
            SELECT [Id], @iNextVersion, [Language], [Text] 
            FROM [SAT].[LocalizableTexts] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts) ;
    SET IDENTITY_INSERT [SAT].[LocalizableTexts] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

 SET IDENTITY_INSERT [SAT].[Blocks] ON; 
      INSERT INTO [SAT].[Blocks] ([Id], [Version], [Name], [Description], [EnableLooping], [MaxLoopSize], [UseDefaultTheme], [DisplayShortcuts], [AutoPageBreakAfterQuestion], [MaxNumberOfQuestionsPerPage], [AutoAdvance], [QuestionnaireId], [Position], [IsSection], [Theme_Id], [Theme_Version]) 
                 SELECT [Id], @iNextVersion, [Name], [Description], [EnableLooping], [MaxLoopSize], [UseDefaultTheme], [DisplayShortcuts], [AutoPageBreakAfterQuestion], [MaxNumberOfQuestionsPerPage], [AutoAdvance], [QuestionnaireId], [Position], [IsSection], [Theme_Id], (CASE WHEN [Theme_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[Blocks] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlocks) 
    SET IDENTITY_INSERT [SAT].[Blocks] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
 SET IDENTITY_INSERT [SAT].[BlockItems] ON; 
    INSERT INTO [SAT].[BlockItems] ([Id], [Version], [BlockId], [Position]) 
            SELECT [Id], @iNextVersion, [BlockId], [Position] 
            FROM [SAT].[BlockItems] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlockItems) 
    SET IDENTITY_INSERT [SAT].[BlockItems] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[BlockItems_Question] ([Name], [Active], [AnswerRequired], [QuestionCategoryId], [CreationDate], [CreatedBy], [LastModificationDate], [LastModifiedBy], [Id], [Version], [Type_Id]) 
            SELECT [Name], [Active], [AnswerRequired], [QuestionCategoryId], [CreationDate], [CreatedBy], [LastModificationDate], [LastModifiedBy], [Id], @iNextVersion, [Type_Id] 
            FROM [SAT].[BlockItems_Question] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlockItems_Question) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

    INSERT INTO [SAT].[BlockItems_PageBreak] ([Id], [Version]) 
            SELECT [Id], @iNextVersion 
            FROM [SAT].[BlockItems_PageBreak] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlockItems_PageBreak) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[BlockItems_LibraryQuestion] ([ContextId], [Id], [Version]) 
            SELECT [ContextId], [Id], @iNextVersion 
            FROM [SAT].[BlockItems_LibraryQuestion] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlockItems_LibraryQuestion) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

    SET IDENTITY_INSERT [SAT].[ChoiceLists] ON; 
    INSERT INTO [SAT].[ChoiceLists] ([Id], [Version], [MaxChoicesCodeLength], [QuestionnaireVersionId], [CompiledJSON]) 
            SELECT [Id], @iNextVersion, [MaxChoicesCodeLength], [QuestionnaireVersionId], [CompiledJSON] 
            FROM [SAT].[ChoiceLists] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblChoiceLists) 
    SET IDENTITY_INSERT [SAT].[ChoiceLists] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    SET IDENTITY_INSERT [SAT].[Choices] ON; 
    INSERT INTO [SAT].[Choices] ([Id], [Version], [QuestionId], [ChoiceListId], [Available], [Exclusive], [Fixed], [Default], [OpenEndType], [OpenEndHeight], [OpenEndWidth], [OpenEndMaxLength], [OpenEndMinLength], [OpenEndDisplayWhenSelected], [Visible], [Value], [Position], [ParentValue], [SkipToQuestion_Id], [SkipToQuestion_Version], [EnforceOpenEnd], [OpenEndLines], [OpenEndSize]) 
                 SELECT [Id], @iNextVersion, [QuestionId], [ChoiceListId], [Available], [Exclusive], [Fixed], [Default], [OpenEndType], [OpenEndHeight], [OpenEndWidth], [OpenEndMaxLength], [OpenEndMinLength], [OpenEndDisplayWhenSelected], [Visible], [Value], [Position], [ParentValue], [SkipToQuestion_Id], (CASE WHEN [SkipToQuestion_Id] is NULL THEN NULL ELSE @iNextVersion END), [EnforceOpenEnd], [OpenEndLines], [OpenEndSize]
            FROM [SAT].[Choices] ins 
            WHERE  [Id] IN (SELECT [Id] FROM #tblChoices) AND [Version] = @iCurrentVersion 
    SET IDENTITY_INSERT [SAT].[Choices] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
 SET IDENTITY_INSERT [SAT].[Variables] ON; 
      INSERT INTO [SAT].[Variables] ([Id], [Version], [Name], [QuestionId], [VariableType], [HasOpenEnd], [MaxMention], [DataType], [Position], [ChoiceListId], [ChoiceListVersion]) 
                 SELECT [Id], @iNextVersion, [Name], [QuestionId], [VariableType], [HasOpenEnd], [MaxMention], [DataType], [Position], [ChoiceListId], (CASE WHEN [ChoiceListId] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[Variables] ins 
            WHERE [Id] IN (SELECT [Id] FROM #tblVariables)  AND [Version] = @iCurrentVersion
    SET IDENTITY_INSERT [SAT].[Variables] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
 
 SET IDENTITY_INSERT [SAT].[QuestionActions] ON; 
    INSERT INTO [SAT].[QuestionActions] ([Id], [Version], [Position], [ActionType], [Condition]) 
            SELECT [Id], @iNextVersion, [Position], [ActionType], [Condition] 
            FROM [SAT].[QuestionActions] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionActions) ;
    SET IDENTITY_INSERT [SAT].[QuestionActions] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[QuestionActions_QuestionPreLoadAction] ([QuestionId], [Id], [Version]) 
            SELECT [QuestionId], [Id], @iNextVersion 
            FROM [SAT].[QuestionActions_QuestionPreLoadAction] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionActions_QuestionPreLoadAction) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[QuestionActions_QuestionPostAnswerAction] ([QuestionId], [Id], [Version]) 
            SELECT [QuestionId], [Id], @iNextVersion 
            FROM [SAT].[QuestionActions_QuestionPostAnswerAction] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionActions_QuestionPostAnswerAction) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
         
 SET IDENTITY_INSERT [SAT].[SkipLogics] ON; 
    INSERT INTO [SAT].[SkipLogics] ([Id], [Version], [Syntax], [ConditionType], [SyntaxType], [QuestionnaireId]) 
            SELECT [Id], @iNextVersion, [Syntax], [ConditionType], [SyntaxType], [QuestionnaireId] 
            FROM [SAT].[SkipLogics] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics) 
            AND (ins.[QuestionnaireId] IS NULL OR EXISTS (SELECT NULL FROM [SAT].[QuestionnaireVersions] ref WHERE ref.[Id] = ins.[QuestionnaireId] AND ref.[Version] = @iNextVersion));
    SET IDENTITY_INSERT [SAT].[SkipLogics] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

    SET IDENTITY_INSERT [SAT].[SkipLogicConditions] ON; 
    INSERT INTO [SAT].[SkipLogicConditions] ([Id], [Version], [OperatorType], [Value], [ShortcutId], [VariableToEvaluateId]) 
            SELECT [Id], @iNextVersion, [OperatorType], [Value], [ShortcutId], [VariableToEvaluateId] 
            FROM [SAT].[SkipLogicConditions] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogicConditions) 
    SET IDENTITY_INSERT [SAT].[SkipLogicConditions] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    SET IDENTITY_INSERT [SAT].[QuestionsRandomizations] ON; 
    INSERT INTO [SAT].[QuestionsRandomizations] ([Id], [Version], [RandomizationPatternType], [StartQuestionId], [EndQuestionId], [BlockId], [Position], [SynchronizeWithId], [GroupCount]) 
            SELECT [Id], @iNextVersion, [RandomizationPatternType], [StartQuestionId], [EndQuestionId], [BlockId], [Position], [SynchronizeWithId], [GroupCount] 
            FROM [SAT].[QuestionsRandomizations] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionsRandomizations) 
    SET IDENTITY_INSERT [SAT].[QuestionsRandomizations] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
     
    SET IDENTITY_INSERT [SAT].[ChoiceSettings] ON; 
    INSERT INTO [SAT].[ChoiceSettings] ([Id], [Version], [ChoiceId], [Name], [Value]) 
            SELECT [Id], @iNextVersion, [ChoiceId], [Name], [Value] 
            FROM [SAT].[ChoiceSettings] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblChoiceSettings) 
    SET IDENTITY_INSERT [SAT].[ChoiceSettings] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[SkipLogics_QuestionSettingSkipLogic] ([QuestionId], [Id], [Version])
            SELECT [QuestionId], [Id], @iNextVersion 
            FROM [SAT].[SkipLogics_QuestionSettingSkipLogic] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics_QuestionSettingSkipLogic) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    SET IDENTITY_INSERT [SAT].[QuestionSettings] ON; 
    INSERT INTO [SAT].[QuestionSettings] ([Id], [Version], [QuestionId], [Value], [QuestionSettingDefinitionId], [SkipLogic_Id], [SkipLogic_Version]) 
            SELECT [Id], @iNextVersion, [QuestionId], [Value], [QuestionSettingDefinitionId], [SkipLogic_Id], (CASE WHEN [SkipLogic_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[QuestionSettings] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionSettings) 
    SET IDENTITY_INSERT [SAT].[QuestionSettings] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
    
    SET IDENTITY_INSERT [SAT].[ThemeElementProperties] ON; 
    INSERT INTO [SAT].[ThemeElementProperties] ([Id], [Version], [ThemeElementType], [ThemeId], [Name], [Value]) 
            SELECT [Id], @iNextVersion, [ThemeElementType], [ThemeId], [Name], [Value] 
            FROM [SAT].[ThemeElementProperties] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblThemeElementProperties) 
    SET IDENTITY_INSERT [SAT].[ThemeElementProperties] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    SET IDENTITY_INSERT [SAT].[QuestionActionProperties] ON; 
    INSERT INTO [SAT].[QuestionActionProperties] ([Id], [Version], [Name], [Value], [QuestionActionId]) 
            SELECT [Id], @iNextVersion, [Name], [Value], [QuestionActionId] 
            FROM [SAT].[QuestionActionProperties] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionActionProperties) 
    SET IDENTITY_INSERT [SAT].[QuestionActionProperties] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

    SET IDENTITY_INSERT [SAT].[VariableSettings] ON; 
    INSERT INTO [SAT].[VariableSettings] ([Id], [Version], [Value], [VariableId], [VariableSettingDefinitionId]) 
            SELECT [Id], @iNextVersion, [Value], [VariableId], [VariableSettingDefinitionId] 
            FROM [SAT].[VariableSettings] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblVariableSettings) 
    SET IDENTITY_INSERT [SAT].[VariableSettings] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
        
    INSERT INTO [SAT].[LocalizableTexts_QuestionShortText] ([QuestionId], [Id], [Version]) 
            SELECT [QuestionId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_QuestionShortText] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionShortText) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[LocalizableTexts_QuestionText] ([QuestionId], [Id], [Version]) 
            SELECT [QuestionId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_QuestionText] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionText) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

    INSERT INTO [SAT].[LocalizableTexts_QuestionTitle] ([QuestionId], [Id], [Version]) 
            SELECT [QuestionId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_QuestionTitle] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionTitle) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[LocalizableTexts_QuestionnaireMessageText] ([ErrorMessageId], [QuestionnaireId], [Id], [Version]) 
            SELECT [ErrorMessageId], [QuestionnaireId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_QuestionnaireMessageText] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionnaireMessageText) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[LocalizableTexts_QuestionnaireTerminationText] ([QuestionnaireId], [Id], [Version]) 
            SELECT [QuestionnaireId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_QuestionnaireTerminationText] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionnaireTerminationText) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[LocalizableTexts_ChoiceText] ([ChoiceId], [Id], [Version]) 
            SELECT [ChoiceId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_ChoiceText] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_ChoiceText) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
       
    INSERT INTO [SAT].[LocalizableTexts_ThemeText] ([ThemeDefaultTextId], [ThemeId], [Id], [Version]) 
            SELECT [ThemeDefaultTextId], [ThemeId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_ThemeText] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_ThemeText) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

    INSERT INTO [SAT].[SkipLogics_QuestionAskLogic] ([Id], [Version], [QuestionQuestionAskLogic_QuestionAskLogic_Id], [QuestionQuestionAskLogic_QuestionAskLogic_Version]) 
            SELECT [Id], @iNextVersion, [QuestionQuestionAskLogic_QuestionAskLogic_Id], (CASE WHEN [QuestionQuestionAskLogic_QuestionAskLogic_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[SkipLogics_QuestionAskLogic] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics_QuestionAskLogic) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[SkipLogics_SkipQuestionLogic] ([Id], [Version], [QuestionQuestionSkipLogic_QuestionSkipLogic_Id], [QuestionQuestionSkipLogic_QuestionSkipLogic_Version]) 
            SELECT [Id], @iNextVersion, [QuestionQuestionSkipLogic_QuestionSkipLogic_Id], (CASE WHEN [QuestionQuestionSkipLogic_QuestionSkipLogic_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[SkipLogics_SkipQuestionLogic] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics_SkipQuestionLogic) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

    INSERT INTO [SAT].[LocalizableTexts_TranslatableQuestionSetting] ([QuestionId], [QuestionSettingDefinitionId], [Id], [Version], [SkipLogic_Id], [SkipLogic_Version]) 
            SELECT [QuestionId], [QuestionSettingDefinitionId], [Id], @iNextVersion, [SkipLogic_Id], (CASE WHEN [SkipLogic_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[LocalizableTexts_TranslatableQuestionSetting] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_TranslatableQuestionSetting) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[SkipLogics_BlockSkipLogic] ([Id], [Version], [BlockBlockSkipLogic_BlockSkipLogic_Id], [BlockBlockSkipLogic_BlockSkipLogic_Version]) 
            SELECT [Id], @iNextVersion, [BlockBlockSkipLogic_BlockSkipLogic_Id], (CASE WHEN [BlockBlockSkipLogic_BlockSkipLogic_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[SkipLogics_BlockSkipLogic] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics_BlockSkipLogic) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
            
    INSERT INTO [SAT].[SkipLogics_VariableSkipLogic] ([Id], [Version], [Variable_Id], [Variable_Version]) 
            SELECT [Id], @iNextVersion, [Variable_Id], (CASE WHEN [Variable_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[SkipLogics_VariableSkipLogic] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics_VariableSkipLogic) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

    INSERT INTO [SAT].[SkipLogics_ChoiceSkipLogic] ([Id], [Version], [Choice_Id], [Choice_Version]) 
            SELECT [Id], @iNextVersion, [Choice_Id], (CASE WHEN [Choice_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[SkipLogics_ChoiceSkipLogic] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics_ChoiceSkipLogic) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[SkipLogics_ChoiceDisplayLogic] ([Id], [Version], [Choice_Id], [Choice_Version]) 
            SELECT [Id], @iNextVersion, [Choice_Id], (CASE WHEN [Choice_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[SkipLogics_ChoiceDisplayLogic] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics_ChoiceDisplayLogic) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[LocalizableTexts_TranslatableVariableSetting] ([VariableId], [VariableSettingDefinitionId], [Id], [Version])
            SELECT [VariableId], [VariableSettingDefinitionId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_TranslatableVariableSetting] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_TranslatableVariableSetting) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[SkipLogics_QuestionActionExecutionCondition] ([Id], [Version], [QuestionAction_Id], [QuestionAction_Version]) 
            SELECT [Id], @iNextVersion, [QuestionAction_Id], (CASE WHEN [QuestionAction_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[SkipLogics_QuestionActionExecutionCondition] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics_QuestionActionExecutionCondition) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[LocalizableTexts_TranslatableChoiceSetting] ([Name], [ChoiceId], [Id], [Version]) 
            SELECT [Name], [ChoiceId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_TranslatableChoiceSetting] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_TranslatableChoiceSetting) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[Themes_LibraryTheme] ([ContextId], [Id], [Version]) 
            SELECT [ContextId], [Id], @iNextVersion 
            FROM [SAT].[Themes_LibraryTheme] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblThemes_LibraryTheme) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
   INSERT INTO [SAT].[SurveyOptions] ([Id], [Version], [AutomaticCleaning], [AutoSubmitAnwers], [InputRequired], [PageOptionType], [SurveyTerminationOptionType], [SurveyTerminationValue], [DefaultLanguage], [DisplayErrorAsPopUps], [LastModifiedBy], [LastModificationDate], [DisableSmartPhoneMobileSupport], [DisableTabletMobileSupport], [DisableTabletGridMobileRendering], [DisableSmartPhoneGridMobileRendering], [UnknownDeviceHandlingType], [UnsupportedDeviceHandlingType], [UnknownDeviceRedirectURL], [UnsupportedDeviceRedirectURL], [CollectRespondentGeoLocation], [MobileDeviceHandlingType], [TabletDeviceHandlingType], [MobileDeviceRedirectURL], [TabletDeviceRedirectURL], [ExecuteAdvancedActionsOnResume], [Points], [QuitButtonType], [AutoSynchronizePanelData], [AutoSynchronizePanelDataExclusionFilter], [AllowCaseCreationOnMobileDevices], [CompletionQuestion_Id], [CompletionQuestion_Version], [StartQuestion_Id], [StartQuestion_Version], [ResumeCompletedQuestion_Id], [ResumeCompletedQuestion_Version], [ResumeNotCompletedQuestion_Id], [ResumeNotCompletedQuestion_Version], [ProgressionStartQuestion_Id], [ProgressionStartQuestion_Version], [ProgressionEndQuestion_Id], [ProgressionEndQuestion_Version], [QuitButtonBranchToQuestion_Id], [QuitButtonBranchToQuestion_Version], [ResponseChangeTrackingMode], [ResponseChangeTrackingVariables], [CleanCallingQuestionOnPreloadBranching], [SAMLAttribute], [CompletedTerminationAction], [CompletedRedirectUrl], [ScreenedOutTerminationAction], [ScreenedOutRedirectUrl], [InterruptedTerminationAction], [InterruptedRedirectUrl], [SurveyProviderVariableName], [SaveRespondentQuestionsDisplayOrder], [PIIVariables] ,[SurveyAutoAdvanceMode], [ViewResponsesExcludedVariables], [OpenEndAnalysisVariables], [SaveRespondentRandomizationPosition])
                 SELECT [Id], @iNextVersion, [AutomaticCleaning], [AutoSubmitAnwers], [InputRequired], [PageOptionType], [SurveyTerminationOptionType], [SurveyTerminationValue], [DefaultLanguage], [DisplayErrorAsPopUps], [LastModifiedBy], [LastModificationDate], [DisableSmartPhoneMobileSupport], [DisableTabletMobileSupport], [DisableTabletGridMobileRendering], [DisableSmartPhoneGridMobileRendering], [UnknownDeviceHandlingType], [UnsupportedDeviceHandlingType], [UnknownDeviceRedirectURL], [UnsupportedDeviceRedirectURL], [CollectRespondentGeoLocation], [MobileDeviceHandlingType], [TabletDeviceHandlingType], [MobileDeviceRedirectURL], [TabletDeviceRedirectURL], [ExecuteAdvancedActionsOnResume], [Points], [QuitButtonType], [AutoSynchronizePanelData], [AutoSynchronizePanelDataExclusionFilter], [AllowCaseCreationOnMobileDevices], [CompletionQuestion_Id], (CASE WHEN [CompletionQuestion_Id] is NULL THEN NULL ELSE @iNextVersion END), [StartQuestion_Id], (CASE WHEN [StartQuestion_Id] is NULL THEN NULL ELSE @iNextVersion END), [ResumeCompletedQuestion_Id], (CASE WHEN [ResumeCompletedQuestion_Id] is NULL THEN NULL ELSE @iNextVersion END), [ResumeNotCompletedQuestion_Id], (CASE WHEN [ResumeNotCompletedQuestion_Id] is NULL THEN NULL ELSE @iNextVersion END), [ProgressionStartQuestion_Id], (CASE WHEN [ProgressionStartQuestion_Id] is NULL THEN NULL ELSE @iNextVersion END), [ProgressionEndQuestion_Id], (CASE WHEN [ProgressionEndQuestion_Id] is NULL THEN NULL ELSE @iNextVersion END), [QuitButtonBranchToQuestion_Id], (CASE WHEN [QuitButtonBranchToQuestion_Id] is NULL THEN NULL ELSE @iNextVersion END), [ResponseChangeTrackingMode], [ResponseChangeTrackingVariables], [CleanCallingQuestionOnPreloadBranching], [SAMLAttribute], [CompletedTerminationAction], [CompletedRedirectUrl], [ScreenedOutTerminationAction], [ScreenedOutRedirectUrl], [InterruptedTerminationAction], [InterruptedRedirectUrl], [SurveyProviderVariableName], [SaveRespondentQuestionsDisplayOrder], [PIIVariables], [SurveyAutoAdvanceMode], [ViewResponsesExcludedVariables], [OpenEndAnalysisVariables], [SaveRespondentRandomizationPosition]
            FROM [SAT].[SurveyOptions] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSurveyOptions) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
 SET IDENTITY_INSERT [SAT].[Shortcuts] ON; 
    INSERT INTO [SAT].[Shortcuts] ([Id], [Version], [Position], [BlockId], [ExitToType], [SurveyOptionsId]) 
            SELECT [Id], @iNextVersion, [Position], [BlockId], [ExitToType], [SurveyOptionsId] 
            FROM [SAT].[Shortcuts] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblShortcuts) 
    SET IDENTITY_INSERT [SAT].[Shortcuts] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

    SET IDENTITY_INSERT [SAT].[BlocksRandomizations] ON; 
    INSERT INTO [SAT].[BlocksRandomizations] ([Id], [Version], [RandomizationPatternType], [EndBlockId], [StartBlockId], [SurveyOptionsId], [Position], [SynchronizeWithId], [SeedAjustment]) 
            SELECT [Id], @iNextVersion, [RandomizationPatternType], [EndBlockId], [StartBlockId], [SurveyOptionsId], [Position], [SynchronizeWithId], [SeedAjustment]
            FROM [SAT].[BlocksRandomizations] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlocksRandomizations) 
    SET IDENTITY_INSERT [SAT].[BlocksRandomizations] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[LocalizableTexts_ShortcutButtonText] ([ShortcutId], [Id], [Version]) 
            SELECT [ShortcutId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_ShortcutButtonText] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_ShortcutButtonText) 
    --SET IDENTITY_INSERT [SAT].[LocalizableTexts_ShortcutButtonText] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
    
    DROP TABLE #tblQuestionnaireVersions;
    DROP TABLE #tblChoices;
    DROP TABLE #tblBlocks;
    DROP TABLE #tblSkipLogicConditions;
    DROP TABLE #tblQuestionsRandomizations;
    DROP TABLE #tblBlockItems;
    DROP TABLE #tblVariables;
    DROP TABLE #tblChoiceSettings;
    DROP TABLE #tblQuestionSettings;
    DROP TABLE #tblQuestionActions;
    DROP TABLE #tblSurveyOptions;
    DROP TABLE #tblQuestionnaireLanguages;
    DROP TABLE #tblLocalizableTexts;
    DROP TABLE #tblChoiceLists;
    DROP TABLE #tblShortcuts;
    DROP TABLE #tblSkipLogics;
    DROP TABLE #tblBlocksRandomizations;
    DROP TABLE #tblThemes;
    DROP TABLE #tblThemeElementProperties;
    DROP TABLE #tblQuestionActionProperties;
    DROP TABLE #tblVariableSettings;
    DROP TABLE #tblBlockItems_Question;
    DROP TABLE #tblLocalizableTexts_QuestionShortText;
    DROP TABLE #tblLocalizableTexts_QuestionText;
    DROP TABLE #tblLocalizableTexts_QuestionTitle;
    DROP TABLE #tblLocalizableTexts_QuestionnaireMessageText;
    DROP TABLE #tblLocalizableTexts_QuestionnaireTerminationText;
    DROP TABLE #tblLocalizableTexts_ChoiceText;
    DROP TABLE #tblLocalizableTexts_ShortcutButtonText;
    DROP TABLE #tblLocalizableTexts_TranslatableQuestionSetting;
    DROP TABLE #tblQuestionActions_QuestionPreLoadAction;
    DROP TABLE #tblQuestionActions_QuestionPostAnswerAction;
    DROP TABLE #tblLocalizableTexts_ThemeText;
    DROP TABLE #tblSkipLogics_QuestionAskLogic;
    DROP TABLE #tblSkipLogics_SkipQuestionLogic;
    DROP TABLE #tblSkipLogics_BlockSkipLogic;
    DROP TABLE #tblSkipLogics_QuestionSettingSkipLogic;
    DROP TABLE #tblSkipLogics_VariableSkipLogic;
    DROP TABLE #tblSkipLogics_ChoiceSkipLogic;
    DROP TABLE #tblSkipLogics_ChoiceDisplayLogic;
    DROP TABLE #tblLocalizableTexts_TranslatableVariableSetting;
    DROP TABLE #tblSkipLogics_QuestionActionExecutionCondition;
    DROP TABLE #tblLocalizableTexts_TranslatableChoiceSetting;
    DROP TABLE #tblBlockItems_PageBreak;
    DROP TABLE #tblBlockItems_LibraryQuestion;
    DROP TABLE #tblThemes_LibraryTheme;
    
    
    DECLARE @dt DATETIME = GETUTCDATE()
      
    -- For version 0 we dont copy back into the questionnaire question type styles since these are stored in question type style only
    IF @iNextVersion <> 0 
    BEGIN
     -- Copy the styles
     INSERT INTO [SAT].[QuestionnaireQuestionTypeStyles]
        ([QuestionnaireId], [Version], [Id], [Name], [LastModificationDate], [LastModifiedBy], [QuestionTypeId])   
      (SELECT @iQuestionnaireId, @iNextVersion, [Id], [Name], [LastModificationDate], [LastModifiedBy], [QuestionTypeId]
       FROM [QuestionTypeStyles]
       WHERE [ContextId] = @iContextId);
          
     -- Copy the style properties
     INSERT INTO [SAT].[QuestionnaireQuestionTypeStyleProperties]
         ([QuestionnaireId], [Version], [QuestionnaireQuestionTypeStyleId], [Id], [Name], [Value])   
      (SELECT @iQuestionnaireId, @iNextVersion, [QuestionTypeStyle_Id], [Id], [Name], [Value]
       FROM [QuestionTypeStyleProperties]
       WHERE [QuestionTypeStyle_ContextId] = @iContextId);
     
     UPDATE [SAT].[QuestionnaireVersions]
      SET CreatedBy      = @iUserId, CreationDate         = @dt, 
       PublishedBy    = @iUserId, PublishedDate        = @dt, 
       LastModifiedBy = @iUserId, LastModificationDate = @dt
      WHERE Id = @iQuestionnaireId AND Version = @iNextVersion;  
    END
    ELSE
    BEGIN
      DECLARE @publishedDate DATETIME 
      DECLARE @publishedVersion int
    
      SELECT @publishedDate = MAX(qv.[PublishedDate]) , @publishedVersion = MAX(qv.Version)
      FROM [SAT].[QuestionnaireVersions] AS qv 
      WHERE qv.[Id]=@iQuestionnaireId
    
      IF @iCurrentVersion = @publishedVersion 
      BEGIN
       SET @dt = @publishedDate
      END
    
      UPDATE [SAT].[Questionnaires]
         SET LastModifiedBy = @iUserId, LastModificationDate = @dt
         WHERE Id = @iQuestionnaireId; 
    
      UPDATE [SAT].[QuestionnaireVersions]
      SET LastModifiedBy = @iUserId, LastModificationDate = @dt, PublishedDate = NULL
      WHERE Id = @iQuestionnaireId AND Version = @iNextVersion; 
    
      UPDATE t
      SET LastModifiedBy = @iUserId, LastModificationDate = @dt
         FROM [SAT].[Themes] AS t
      INNER JOIN [SAT].[QuestionnaireVersions] AS qv ON qv.[Theme_Id]=t.[Id] 
         WHERE qv.Id = @iQuestionnaireId AND qv.Version = @iNextVersion AND t.Version = @iNextVersion; 
    END
END
'

--declare @SurveyPayload01 nvarchar(max) = N'waitfor delay ''0:00:01'''

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)
create table #Survey (
	DBName nvarchar(128),
	SchemaName nvarchar(128),
	Processed tinyint default 0
)
create table #SurveyVerif (
	DBName nvarchar(128),
	SchemaName nvarchar(128)
)
create table #SurveysDone (
	DBName nvarchar(128) collate database_default,
	SchemaName nvarchar(128) collate database_default
)
declare @AllDone bit = 0, 
        @TotalClients int, 
		@TotalSurveys int, 
		@ClientCounter int, 
		@SurveyCounter int, 
		@ThisClient nvarchar(128), 
		@ThisSurvey nvarchar(128), 
		@ClientCursor cursor, 
		@SurveyCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalClients = 0, @TotalSurveys = 0, @ClientCounter = 0, @SurveyCounter = 0
	insert into #DB 
	select 'A4Survey_Client_' + cast(Id as nvarchar(16)), 0 from Acuity4.dbo.Client
	     
    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Survey_Client_Template', 0)

	select @TotalClients = count(*) 
	       from #DB
	
	set @ClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @ClientCursor
	fetch next from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @ClientCounter += 1
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #Survey select ''' + @ThisClient + ''', SchemaName, 0 from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName, 0 from #SurveysDone'
		exec @DBSQL @SQL
		select @StatusMessage = 'Updating client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ClientCounter / @TotalClients
		raiserror (@StatusMessage, 0, 1, @ThisClient, @ClientCounter, @TotalClients, @StatusPercent) with nowait
		
		print 'Client Payload 1'
		select @SQL = replace(replace(@ClientPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'All Client Payload done for  client ' + @ThisClient + '!'

		update #DB set Processed = 1 where current of @ClientCursor
		fetch next from @ClientCursor into @ThisClient
	end


	close @ClientCursor
	deallocate @ClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Survey_Client_Template';
      SET @SQL = 'USE Acuity4;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
drop table #Survey
drop table #SurveyVerif
drop table #SurveysDone